import React from 'react';

import { ONE_SECOND, ONE_WEEK } from 'constants/constants';

import { buildMotorHoursData } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/MotorHours/buildWeekMotorHoursData';
import { ICarCardInformersChartProps, SENSORS } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';
import useSensorsData from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/useSensorsData';
import Informer from 'components/Informer';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/MotorHours/MotorHoursAllInformer.i18n';

export interface MotoHoursAllInformerOptions {
    setMax?: (max: number) => void;
}

export default function MotoHoursAllInformer({
    className,
    car_id,
    type,
    hideHeader,
    setMax,
}: ICarCardInformersChartProps & MotoHoursAllInformerOptions) {
    let locale = 'ru';

    let [isLoading, , chart_data, getSensor] = useSensorsData<any>({
        handler: (data) => {
            return buildMotorHoursData(data?.activities[0].values || []) || [];
        },
    });

    React.useEffect(() => {
        car_id &&
            getSensor({
                car_id,
                since: Math.trunc((+new Date() - ONE_WEEK) / ONE_SECOND),
                until: Math.trunc(+new Date() / ONE_SECOND),
                sensor_id: SENSORS.MOTOR_HOURS,
            });
    }, [car_id]);

    let max: number =
        chart_data?.reduce((p, c) => {
            return p + +c.y;
        }, 0) || 0;

    let avgValue = +(max / chart_data.length).toFixed(1) || 0;

    React.useEffect(() => {
        if (setMax) {
            setMax(avgValue);
        }
    }, [avgValue, setMax]);

    return (
        <Informer
            className={className}
            data={chart_data}
            type={type}
            title={i18n('Engine hours')}
            isLoading={isLoading}
            value={`${avgValue.toLocaleString(locale)} ${i18n('h')}`}
            hideHeader={hideHeader}
        />
    );
}
