import { DAYS_IN_WEEK, ONE_DAY, ONE_SECOND, SECONDS_IN_HOUR } from 'constants/constants';

import { dateToShortString } from 'utils/dateToShortString';
import { sortInformersDate } from 'utils/informers/sortInformersDate';

import { ISensorsHistoryValueItem } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';

export const buildMotorHoursData = (data: ISensorsHistoryValueItem[]): any[] => {
    let days: Record<string, { timestamp: number; value: number }> = {};
    let currentDay = Date.now();

    for (let i = 0; i <= DAYS_IN_WEEK; i++) {
        let timestamp = currentDay - ONE_DAY * i;
        let key = dateToShortString(timestamp);

        days[key] = { timestamp, value: 0 };
    }

    data.forEach((el: { value: number; timestamp: number }) => {
        let value = el.value / SECONDS_IN_HOUR;
        let timestamp = el.timestamp * ONE_SECOND;
        let key = dateToShortString(timestamp);

        if (days[key]) {
            days[key].value += value;
        }
    });

    return Object.values(days)
        .sort(sortInformersDate)
        .map(({ timestamp, value }) => {
            return {
                x: dateToShortString(timestamp),
                y: value.toFixed(1),
            };
        });
};
