import React, { useState } from 'react';

import { DAYS_IN_MONTH, ONE_MONTH, ONE_SECOND } from 'constants/constants';

import { showCarScoringMedian } from 'utils/showCarScoringMedian';

import { useCarScoringData } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Scoring/useCarScoringData';
import { ICarCardInformersChartProps } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';
import { DashedLabel } from 'components/Informer';
import { buildScoringData } from 'components/Scoring/ScoringInformer/buildScoringData';
import { buildScoringMedianData } from 'components/Scoring/ScoringInformer/buildScoringMedianData';
import { ScoringInformer } from 'components/Scoring/ScoringInformer/ScoringInformer';
import { useScoringMedianData } from 'components/Scoring/ScoringInformer/useScoringMedianData';

export default function CarScoringInformer({
    className,
    tag_id,
    type,
    car_id,
    hideHeader,
}: ICarCardInformersChartProps) {
    let [isLoading, , chart_data, getData] = useCarScoringData<any>({
        handler: (data) => {
            return buildScoringData(data?.records);
        },
    });

    let [, , chart_data_median, getMedianData] = useScoringMedianData<any>({
        handler: (data) => {
            return buildScoringMedianData(data);
        },
    });

    let [additionalHeaders, setAdditionalHeader] = useState<any[]>([]);

    React.useEffect(() => {
        if (tag_id) {
            let currentDate = Date.now();

            getData({
                since: Math.trunc((currentDate - ONE_MONTH) / ONE_SECOND),
                until: Math.trunc(currentDate / ONE_SECOND),
                tag_id,
            });

            if (showCarScoringMedian()) {
                getMedianData({
                    car_id,
                    limit: DAYS_IN_MONTH,
                });

                setAdditionalHeader([<DashedLabel key={0} />]);
            }
        }
    }, [tag_id]);

    return (
        <ScoringInformer
            className={className}
            chartData={chart_data}
            chartMedianData={chart_data_median}
            type={type}
            additionalHeaders={additionalHeaders}
            isLoading={!tag_id ? false : isLoading}
            hideHeader={hideHeader}
        />
    );
}
