import React, { MutableRefObject, useRef } from 'react';

import { CARS_REQUESTS, REQUESTS } from 'components/Cars/request';

import { RequestHelper } from '../../../../../../../request-helper/src';

interface UseCarScoringDataProps<T> {
    handler: (data?: any) => T | null;
}

export function useCarScoringData<T>({
    handler,
}: UseCarScoringDataProps<T>): [boolean, null | Error, T | null, (props) => void] {
    let [isLoading, setLoading] = React.useState(true);
    let [error, seError] = React.useState(null);
    let [data, setHistoryValues] = React.useState<any>([]);
    let retry = 0;

    const request: MutableRefObject<RequestHelper> = useRef(new RequestHelper({ requestConfigs: CARS_REQUESTS }));

    const getData = (queryParams) => {
        setLoading(true);
        request.current
            .exec(REQUESTS.GET_SCORING_HISTORY, { queryParams })
            .then((response) => {
                setHistoryValues(handler(response));
            })
            .catch((error) => {
                seError(error);

                if (!retry) {
                    getData(queryParams);
                    retry++;
                }
            })
            .finally(() => {
                setLoading(false);
            });
    };

    React.useEffect(() => {
        return () => {
            request.current.abort();
        };
    }, []);

    return [isLoading, error, data, getData];
}
