import React from 'react';

import { showCarScoring } from 'utils/showCarScoring';

import MileageAllInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Mileage/MileageAllInformer';
import MotoHoursAllInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/MotorHours/MotorHoursAllInformer';
import CarScoringInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Scoring/CarScoringInformer';
import { CharType, InformersGrid } from 'components/Informer';

export default function CarCardInformers({ carInfo }) {
    let car_id = carInfo?.id || '';
    let tag_id = carInfo?.aggressive_score_tag_id;

    return (
        <InformersGrid>
            {showCarScoring() ? (
                <CarScoringInformer
                    tag_id={tag_id}
                    type={CharType.line}
                    car_id={car_id}
                />
            ) : null}

            <MileageAllInformer
                car_id={car_id}
                type={CharType.line}
            />

            <MotoHoursAllInformer
                car_id={car_id}
                type={CharType.bar}
            />
        </InformersGrid>
    );
}
