import React, { MutableRefObject, useRef } from 'react';

import { ISensorsRawResponseData } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';
import { CARS_REQUESTS, REQUESTS } from 'components/Cars/request';

import { RequestHelper } from '../../../../../../request-helper/src';

interface IUseSensorsDataProps<T> {
    handler: (data?: ISensorsRawResponseData) => T | null;
}

export default function useSensorsData<T>({
    handler,
}: IUseSensorsDataProps<T>): [boolean, null | Error, T | null, (props) => void] {
    let [isLoading, setLoading] = React.useState(true);
    let [error, seError] = React.useState(null);
    let [data, setHistoryValues] = React.useState<any>([]);
    let retry = 0;

    const request: MutableRefObject<RequestHelper> = useRef(new RequestHelper({ requestConfigs: CARS_REQUESTS }));

    const getSensor = (queryParams) => {
        setLoading(true);
        request.current
            .exec(REQUESTS.GET_TELEMATICS_HISTORY, { queryParams })
            .then((response) => {
                setHistoryValues(handler(response));
            })
            .catch((error) => {
                seError(error);
                if (!retry) {
                    getSensor(queryParams);
                    retry++;
                }
            })
            .finally(() => {
                setLoading(false);
            });
    };

    React.useEffect(() => {
        return () => {
            request.current.abort();
        };
    }, []);

    return [isLoading, error, data, getSensor];
}
