import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Search mode': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode',
        ru: 'Режим "Слежения"',
        cs: 'Režim vyhledávání',
    },
    'Search mode was disabled': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode was disabled',
        ru: 'Режим "Слежения" выключен',
        cs: 'Režim vyhledávání byl deaktivován',
    },
    'Search mode was enabled': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode was enabled',
        ru: 'Режим "Слежения" включён',
        cs: 'Režim vyhledávání byl aktivován',
    },
    'The beacon is waiting for the mode switch...': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The beacon is waiting for the mode switch...',
        ru: 'Маяк в ожидании переключения режима...',
        cs: 'Maják čeká na přepnutí režimu...',
    },
    'The beacon transmits data 2 times a day': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The beacon transmits data 2 times a day',
        ru: 'Маяк передаёт данные 2 раза в сутки',
        cs: 'Maják přenáší data 2krát denně',
    },
    'The beacon transmits data every 20 minutes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The beacon transmits data every 20 minutes',
        ru: 'Маяк передаёт данные каждые 20 минут',
        cs: 'Maják přenáší data každých 20 minut',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
