import React, { useState } from 'react';

import { RequestError } from '../../../../../../../../request-helper/src';

import Arrow from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarControlConfirm/ErrorBlock/arraw.component.svg';

import styles from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarControlConfirm/ErrorBlock/index.css';

interface IErrorBlockProps {
    error: RequestError;
}

export default function ErrorBlock({ error }: IErrorBlockProps) {
    let [isCollapsed, toggle] = useState(true);

    return (
        <div className={`${styles.component}`}>
            <div className={`${styles.title}`}>
                <div>
                    {error?.statusText}: {error?.status}
                </div>
                <div
                    onClick={toggle.bind(null, !isCollapsed)}
                    className={`${styles.arrow} ${!isCollapsed && styles.rotate}`}
                >
                    <Arrow />
                </div>
            </div>
            {!isCollapsed && <div className={`${styles.details}`}>{JSON.stringify(error)}</div>}
        </div>
    );
}
