import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Execute the command?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Execute the command?',
        ru: 'Точно выполнить команду?',
        cs: 'Provést příkaz?',
    },
    No: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'No',
        ru: 'Нет',
        cs: 'Ne',
    },
    'Try again': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Try again',
        ru: 'Попробовать снова',
        cs: 'Zkuste to znovu',
    },
    'Yes, execute': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, execute',
        ru: 'Да, выполнить',
        cs: 'Ano, provést',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
