import { RequestHelperConfigs, RequestHelperMethod } from '../../../../../../../request-helper/src';

enum REQUESTS {
    CAR_CONTROL = 'CAR_CONTROL',
    ADD_CAR_TAG = 'ADD_CAR_TAG',
    REMOVE_CAR_TAG = 'REMOVE_CAR_TAG',
}

const CAR_CONTROL_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.CAR_CONTROL]: {
        method: RequestHelperMethod.POST,
        api: 'car/control',
        cgiObj: {
            car_id: null,
            command: null,
        },
    },
    [REQUESTS.ADD_CAR_TAG]: {
        method: RequestHelperMethod.POST,
        api: 'car/tag/add',
        cgiObj: {
            car_number: null,
            car_id: null,
            tag: null,
        },
    },
    [REQUESTS.REMOVE_CAR_TAG]: {
        method: RequestHelperMethod.POST,
        api: 'car/tag/remove',
        cgiObj: {
            tag_names: null,
            object_ids: null,
        },
    },
};

export { CAR_CONTROL_REQUESTS, REQUESTS };
