import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Move to service?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Move to service?',
        ru: 'Перевести в сервисный режим?',
        cs: 'Přesunout do servisu?',
    },
    'Return from service?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return from service?',
        ru: 'Снять сервисный режим?',
        cs: 'Vrátit ze servisu?',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
