import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Address: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Address',
        ru: 'Адрес',
        cs: 'Adresa',
    },
    'Current Location': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current Location',
        ru: 'Текущее местоположение',
        cs: 'Aktuální poloha',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
