import * as React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { ICarInfo } from 'utils/car/types';
import initMapApi from 'utils/map/map/initMapApi';

import { getAddress } from 'entities/Geo/helpers/getAddress/getAddress';

import { AreaStatus, AreaStatuses } from 'components/Cars/AreaStatus';
import Header4 from 'components/ui/Text/Header4';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarLocation/index.i18n';

import style from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/index.css';

interface ICarLocationProps {
    isLoading: boolean;
    carInfo: ICarInfo;
    lon: number;
    lat: number;
}

const DENY_AREA_TAG = 'deny';

export const CarLocation = (props: ICarLocationProps) => {
    let { carInfo, isLoading, lon, lat } = props;
    let { tags: tagsLocation = [] } = carInfo?.location ?? {};
    let area = tagsLocation.includes(DENY_AREA_TAG) ? AreaStatuses.RESTRICTED : AreaStatuses.AVAILABLE;

    let [address, setAddress] = React.useState<string | null>(null);
    let mapScript = initMapApi();

    React.useEffect(() => {
        // @ts-ignore
        if (window.ymaps) {
            getAddress([lon, lat]).then((address) => setAddress(address));
        } else {
            mapScript.addEventListener('load', () => {
                getAddress([lon, lat]).then((address) => setAddress(address));
            });
        }
    }, [lon, lat]);

    return (
        <div className={style.car_location}>
            <div className={style.title_container}>
                <Header4 className={style.title}>{isLoading ? null : i18n('Current Location')}</Header4>
                {isLoading ? null : <AreaStatus status={area} />}
            </div>
            <span
                className={style.location}
                title={address ?? i18n('Address')}
            >
                {isLoading ? null : address ?? EMPTY_DATA}
            </span>
        </div>
    );
};
