import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Battery charge': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Battery charge',
        ru: 'Заряд',
        cs: 'Nabití baterie',
    },
    Coordinates: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Coordinates',
        ru: 'Координаты',
        cs: 'Souřadnice',
    },
    'Geodata source': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geodata source',
        ru: 'Источник гео данных',
        cs: 'Zdroj geodat',
    },
    'GPS signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GPS signal',
        ru: 'GPS сигнал',
        cs: 'Signál GPS',
    },
    'GSM signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GSM signal',
        ru: 'GSM сигнал',
        cs: 'Signál GSM',
    },
    Temperature: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Temperature',
        ru: 'Температура',
        cs: 'Teplota',
    },
    'Updated at': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Updated at',
        ru: 'Обновление',
        cs: 'Aktualizováno v',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
