import * as React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { getLastUpdateString } from 'shared/helpers/getLastUpdateString/getLastUpdateString';
import { GPSValueIcon } from 'shared/ui/GPSValueIcon/GPSValueIcon';

import GSMSignalIcon from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/GSMSignalIcon';
import { IBeacon } from 'components/Map/controls/BeaconPinLayout/types';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarTabInformation/BeaconTab/index.i18n';

interface IBeaconTabProps {
    beaconInfo: IBeacon | null;
}

export const getBeaconTab = (props: IBeaconTabProps) => {
    let { beaconInfo } = props;
    let { longitude, latitude, since, type } = beaconInfo?.location ?? {};
    let {
        gsm_level = null,
        satellites_inview = null,
        battery = null,
        internal_temperature = null,
        imei,
    } = beaconInfo ?? {};

    return [
        null,
        {
            key: i18n('Updated at'),
            content: since ? getLastUpdateString(since) : EMPTY_DATA,
        },

        {
            key: 'IMEI',
            content: imei ? `${imei}` : EMPTY_DATA,
        },

        {
            key: i18n('Geodata source'),
            content: type ? `${type}` : EMPTY_DATA,
        },

        {
            key: i18n('Coordinates'),
            content: longitude && latitude ? `${longitude} ${latitude}` : EMPTY_DATA,
        },

        {
            key: i18n('GPS signal'),
            content:
                satellites_inview !== null ? (
                    <div>
                        <GPSValueIcon GPSInview={satellites_inview || 0} />
                    </div>
                ) : (
                    EMPTY_DATA
                ),
        },

        {
            key: i18n('GSM signal'),
            content:
                gsm_level !== null ? (
                    <div>
                        <GSMSignalIcon GSMValue={gsm_level || 0} />
                    </div>
                ) : (
                    EMPTY_DATA
                ),
        },

        {
            key: i18n('Temperature'),
            content: internal_temperature !== null ? `${+internal_temperature.toFixed(1)}°C` : EMPTY_DATA,
        },

        {
            key: i18n('Battery charge'),
            content: battery ? `${battery.toFixed(1)} %` : EMPTY_DATA,
        },
    ];
};
