import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'License plate': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'License plate',
        ru: 'Номер машины',
        cs: 'Registrační značka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
