import { EMPTY_DATA } from 'constants/constants';

import { ICarImei, ICarInfo, ICarScoring } from 'utils/car/types';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarTabInformation/CarTab/index.i18n';

interface ICarTabProps {
    carInfo: ICarInfo & ICarScoring & ICarImei;
}

export const getCarTab = (props: ICarTabProps) => {
    let { carInfo } = props;
    let { vin, imei, number } = carInfo ?? {};

    return [
        { key: 'IMEI', content: imei || EMPTY_DATA },
        { key: 'VIN', content: vin || EMPTY_DATA },
        { key: i18n('License plate'), content: number || EMPTY_DATA },
    ];
};
