import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Alarm fired': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Alarm fired',
        ru: 'Сработала тревога',
        cs: 'Alarm aktivován',
    },
    'Alarm system': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Alarm system',
        ru: 'Сигнализация',
        cs: 'Zabezpečovací systém',
    },
    'Battery charge': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Battery charge',
        ru: 'Заряд',
        cs: 'Nabití baterie',
    },
    'Current speed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current speed',
        ru: 'Текущая скорость',
        cs: 'Aktuální rychlost',
    },
    'Engine temp.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Engine temp.',
        ru: 'Темп. двигателя',
        cs: 'Teplota motoru',
    },
    Fuel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel',
        ru: 'Топливо',
        cs: 'Stav nádrže',
    },
    'GPS signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GPS signal',
        ru: 'GPS сигнал',
        cs: 'Signál GPS',
    },
    'GSM signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GSM signal',
        ru: 'GSM сигнал',
        cs: 'Signál GSM',
    },
    km: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'km',
        ru: 'км',
        cs: 'km',
    },
    Mileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage',
        ru: 'Пробег',
        cs: 'Počet ujetých kilometrů',
    },
    Off: {
        _meta: {
            context: 'Alarm system status',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Off',
        ru: 'Отключена',
        cs: 'Vypnuto',
    },
    On: {
        _meta: {
            context: 'Alarm system status',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'On',
        ru: 'Включена',
        cs: 'Zapnuto',
    },
    Range: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Range',
        ru: 'Запас хода',
        cs: 'Dojezd',
    },
    Scoring: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Scoring',
        ru: 'Скоринг',
        cs: 'Skóre',
    },
    Status: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Status',
        ru: 'Статус',
        cs: 'Stav',
    },
    Updated: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Updated',
        ru: 'Обновлено',
        cs: 'Aktualizováno',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
