import * as React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { ICarImei, ICarInfo, ICarScoring } from 'utils/car/types';

import { StatusTypes } from 'components/types';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/CarTabInformation/index.i18n';

import style from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/index.css';

interface ICarInformationProps {
    carInfo: ICarInfo & ICarScoring & ICarImei;
    isLoading: boolean;
    getInfoArray: () => Array<{
        key: string;
        content?: JSX.Element | string | null;
    } | null> | null;
}

export const CarTabInformation = (props: ICarInformationProps) => {
    let { getInfoArray, isLoading, carInfo } = props;
    let { status = StatusTypes.UNKNOWN } = carInfo ?? {};

    return (
        <table className={style.indicators_table}>
            <tbody>
                {getInfoArray()?.map((infoItem, index) => {
                    if (infoItem === null) {
                        return (
                            <tr
                                key={index}
                                className={style.separator}
                            >
                                <td colSpan={2} />
                            </tr>
                        );
                    }

                    let { key, content } = infoItem;

                    return (
                        <tr key={key}>
                            <td className={style.key_column}>{key}</td>
                            <td>
                                {isLoading ? (
                                    <div className={style.indicator_shimmer} />
                                ) : ![
                                      i18n('Status'),
                                      i18n('GPS signal'),
                                      i18n('GSM signal'),
                                      i18n('Mileage'),
                                      'IMEI',
                                      'VIN',
                                      i18n('Scoring'),
                                  ].includes(key) && status === StatusTypes.NO_SIGNAL ? (
                                    EMPTY_DATA
                                ) : (
                                    content
                                )}
                            </td>
                        </tr>
                    );
                })}
            </tbody>
        </table>
    );
};
