import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import ZeroIcon from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/GSMSignalIcon/zero_value.component.svg';

import style from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/GSMSignalIcon/index.css';

export const GSMSignalStrength = {
    ZERO: 0,
    LOW: 1,
    MEDIUM: 9,
    STRONG: 18,
    STRONGEST: 27,
};

const GSMSignalIcon = ({ GSMValue }: { GSMValue: number | null }) => {
    let colorClassName = null;
    if (GSMValue !== null) {
        if (GSMValue >= GSMSignalStrength.LOW && GSMValue < GSMSignalStrength.MEDIUM) {
            colorClassName = style.low;
        }
        if (GSMValue >= GSMSignalStrength.MEDIUM && GSMValue < GSMSignalStrength.STRONG) {
            colorClassName = style.medium;
        }
        if (GSMValue >= GSMSignalStrength.STRONG) {
            colorClassName = style.strong;
        }
    }

    return GSMValue !== null ? (
        <div className={style.gsm_value_icon_container}>
            <div className={style.gsm_signal_icon}>
                {[
                    GSMSignalStrength.LOW,
                    GSMSignalStrength.MEDIUM,
                    GSMSignalStrength.STRONG,
                    GSMSignalStrength.STRONGEST,
                ].map((minEnablingValue) => {
                    return (
                        <div
                            key={minEnablingValue}
                            className={
                                `${style.signal_icon_stick}` + ` ${GSMValue >= minEnablingValue ? colorClassName : ''}`
                            }
                        />
                    );
                })}
            </div>
            {GSMValue === GSMSignalStrength.ZERO ? (
                <div className={style.zero_value_container}>
                    <ZeroIcon />
                </div>
            ) : null}
        </div>
    ) : (
        <span>{EMPTY_DATA}</span>
    );
};

export default GSMSignalIcon;
