import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { Spin } from 'shared/ui/Spin/Spin';

import { ICommonButtonProps } from 'components/ui/Buttons/Button';

import style from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/ShowOnMapButton/index.css';

interface IShowOnMapButtonProps extends ICommonButtonProps {
    isLoading?: boolean;
}

const ShowOnMapButton = (props: IShowOnMapButtonProps) => {
    let { title, onClick, disabled, isLoading } = props;

    return (
        <button
            disabled={disabled ?? false}
            className={`${style.show_on_map_button}` + ` ${disabled ? style.disabled : ''}`}
            onClick={onClick}
        >
            {isLoading ? <Spin /> : title || EMPTY_DATA}
        </button>
    );
};

export default ShowOnMapButton;
