import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Beacon location': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Beacon location',
        ru: 'Местоположение маяка',
        cs: 'Umístění majáku',
    },
    'GPS location': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GPS location',
        ru: 'Местоположение по GPS',
        cs: 'Poloha GPS',
    },
    'Show on map': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show on map',
        ru: 'Показать на карте',
        cs: 'Zobrazit na mapě',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
