import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { ICarInfo } from 'utils/car/types';

import { CarSchema } from 'entities/Car/types/CarSchema';

import { CarNumberLabel } from 'components/Cars/CarNumberLabel';
import CarStatus from 'components/Cars/CarStatus';

import style from 'components/Cars/CarCard/CarCardOverview/ModalCarInfo/index.css';

interface IModalCarInfo {
    carInfo: ICarInfo | CarSchema;
}

export default function ModalCarInfo({ carInfo }: IModalCarInfo) {
    let { model = null } = carInfo ?? {};

    return (
        <div className={style.car_info}>
            <div className={style.model}>{model ?? EMPTY_DATA}</div>
            <div className={style.car_meta}>
                <CarNumberLabel
                    dark
                    carInfo={carInfo}
                />
                <CarStatus
                    dark
                    carInfo={carInfo}
                    oneRow
                />
            </div>
        </div>
    );
}
