import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Rides: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rides',
        ru: 'Поездки',
        cs: 'Jízdy',
    },
    'Show all': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show all',
        ru: 'Показать все',
        cs: 'Zobrazit vše',
    },
    Signals: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signals',
        ru: 'Сигналы',
        cs: 'Signály',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
