import { EMPTY_DATA, SECONDS_IN_MINUTE } from 'constants/constants';

import { i18n } from 'components/Cars/CarCard/CarSessionsTable/getSessionDurationString.i18n';

export let getSessionDurationString = (duration: number | null) => {
    if (typeof duration !== 'number' || isNaN(duration)) {
        return EMPTY_DATA;
    }
    if ((duration ?? 0) < SECONDS_IN_MINUTE) {
        return `<1 ${i18n('min')}`;
    }

    let fullMinutes = Math.floor((duration ?? 0) / SECONDS_IN_MINUTE);
    let hours = Math.floor(fullMinutes / SECONDS_IN_MINUTE);
    let minutes = fullMinutes % SECONDS_IN_MINUTE;

    return `${hours ? `${hours} ${i18n('h')} ` : ''}${minutes} ${i18n('min')}`;
};
