import { EMPTY_DATA } from 'constants/constants';

import getCoordinatesDiff from 'utils/sessions/getCoordinatesDiff';
import getMileage from 'utils/sessions/getMileage';
import { ISession } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

import { i18n } from 'components/Cars/CarCard/CarSessionsTable/getSessionMileageString.i18n';

export const getSessionMileageString = (session: ISession | RideSchema) => {
    let mileageInKilometers = getMileage(session);
    let coordinatesDiff = getCoordinatesDiff(session);

    if (typeof mileageInKilometers !== 'number' || isNaN(mileageInKilometers)) {
        return EMPTY_DATA;
    }

    return `${
        mileageInKilometers
            ? mileageInKilometers.toFixed(mileageInKilometers % 1 === 0 ? 0 : 1)
            : coordinatesDiff
            ? '<1'
            : mileageInKilometers
    } ${i18n('km')}`;
};
