import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Careless driving': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Careless driving',
        ru: 'Неаккуратное вождение',
        cs: 'Neopatrná jízda',
    },
    'Dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous ride',
        ru: 'Опасная поездка',
        cs: 'Nebezpečná jízda',
    },
    'Date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and time',
        ru: 'Дата и время',
        cs: 'Datum a čas',
    },
    Driver: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver',
        ru: 'Водитель',
        cs: 'Řidič',
    },
    Duration: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Duration',
        ru: 'Длительность',
        cs: 'Doba trvání',
    },
    Mileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage',
        ru: 'Пробег',
        cs: 'Počet ujetých kilometrů',
    },
    Speeding: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Speeding',
        ru: 'Превышение скорости',
        cs: 'Překročení povolené rychlosti',
    },
    'Very dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Very dangerous ride',
        ru: 'Очень опасная поездка',
        cs: 'Velmi nebezpečná jízda',
    },
    Violations: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Violations',
        ru: 'Нарушения',
        cs: 'Přestupky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
