import React from 'react';

import { EMPTY_DATA, ONE_SECOND } from 'constants/constants';

import shortDateTime from 'utils/date/shortDateTime';
import { getI18nLocale } from 'utils/language/getI18nLocale';

import style from 'components/Cars/CarCard/CarSessionsTable/index.css';

type ISessionTimeItem = number | null | undefined;

export const SessionTime = ({
    start,
    finish,
    oneRow,
}: {
    start: ISessionTimeItem;
    finish: ISessionTimeItem;
    oneRow?: boolean;
}) => {
    const locale = getI18nLocale();

    let startDate = start ? new Date(start * ONE_SECOND) : null;
    let finishDate = finish ? new Date(finish * ONE_SECOND) : null;

    let startDateDay = startDate?.getDate();
    let startDateMonth = startDate?.getMonth();
    let finishDateDay = finishDate?.getDate();
    let finishDateMonth = finishDate?.getMonth();

    return (
        <>
            {startDate ? shortDateTime(start) : EMPTY_DATA}
            {finishDate ? <span>{EMPTY_DATA}</span> : null}
            {finishDate ? (
                startDateDay === finishDateDay && startDateMonth === finishDateMonth ? (
                    finishDate.toLocaleString(locale, {
                        hour: '2-digit',
                        minute: '2-digit',
                    })
                ) : (
                    <span className={oneRow ? style.one_row : ''}>{shortDateTime(finish)}</span>
                )
            ) : (
                <div className={style.current_session_icon_container}>
                    <div className={style.current_session_icon} />
                </div>
            )}
        </>
    );
};
