import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Sensor: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Sensor',
        ru: 'Сенсор',
        cs: 'Senzor',
    },
    Start: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Start',
        ru: 'Начало',
        cs: 'Začatek',
    },
    Updated: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Updated',
        ru: 'Обновлено',
        cs: 'Aktualizováno',
    },
    Value: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Value',
        ru: 'Значение',
        cs: 'Hodnota',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
