import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Block car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block car',
        ru: 'Заблокировать',
        cs: 'Blokovat vůz',
    },
    'Close doors': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Close doors',
        ru: 'Закрыть двери',
        cs: 'Zavřete dveře',
    },
    'Move to service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Move to service',
        ru: 'В сервис',
        cs: 'Přesunout do servisu',
    },
    'Open doors': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Open doors',
        ru: 'Открыть двери',
        cs: 'Otevřít dveře',
    },
    'Return from service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return from service',
        ru: 'Из сервиса',
        cs: 'Vrátit ze servisu',
    },
    'Unblock car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock car',
        ru: 'Разблокировать',
        cs: 'Odblokovat vůz',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
