import React from 'react';

import { ControlType } from 'entities/Car';

import ControlButton from 'components/ui/Buttons/ControlButton';

import { i18n } from 'components/Cars/CarControlButton/index.i18n';

import BlockIcon from 'components/Cars/CarControlButton/block_icon.component.svg';
import CloseDoorsIcon from 'components/Cars/CarControlButton/close_doors.component.svg';
import OpenDoorsIcon from 'components/Cars/CarControlButton/open_doors.component.svg';
import Service from 'components/Cars/CarControlButton/service.component.svg';

import style from 'components/Cars/CarControlButton/index.css';

interface ICarControlButtonProps {
    type: ControlType;
    disabled?: boolean;
    onClick: () => void;
}

export const CarControlButton = (props: ICarControlButtonProps) => {
    let { type, disabled, onClick: onClickProps } = props;

    let displayName = '';
    let icon: any = null;
    let critical: boolean = false;
    let description: string | null = null;
    switch (type) {
        case ControlType.block:
            displayName = i18n('Block car');
            icon = <BlockIcon />;
            critical = true;
            break;
        case ControlType.unblock:
            displayName = i18n('Unblock car');
            icon = <BlockIcon />;
            critical = true;
            break;
        case ControlType.open_doors:
            displayName = i18n('Open doors');
            icon = <OpenDoorsIcon />;
            break;
        case ControlType.close_doors:
            displayName = i18n('Close doors');
            icon = <CloseDoorsIcon />;
            break;
        case ControlType.move_to_service:
            displayName = i18n('Move to service');
            icon = <Service />;
            break;
        case ControlType.return_from_service:
            displayName = i18n('Return from service');
            icon = <Service />;
            break;
    }

    const onClick = () => {
        onClickProps();
    };

    let titleComponent = (
        <div className={style.title}>
            {icon}
            {displayName}
        </div>
    );

    return (
        <ControlButton
            title={titleComponent}
            onClick={onClick}
            description={description}
            tertiary
            fullWidth
            leftAlign
            disabled={disabled}
            critical={critical}
        />
    );
};
