import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Battery: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Battery',
        ru: 'Заряд',
        cs: 'Baterie',
    },
    'Current Location': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current Location',
        ru: 'Текущее местоположение',
        cs: 'Aktuální poloha',
    },
    'Current speed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current speed',
        ru: 'Текущая скорость',
        cs: 'Aktuální rychlost',
    },
    Fuel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel',
        ru: 'Топливо',
        cs: 'Stav nádrže',
    },
    'Taxi park': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Taxi park',
        ru: 'Таксопарк',
        cs: 'Taxi',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
