import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { ICarInfo } from 'utils/car/types';
import { getHideTaxiParkDataFlag } from 'utils/getHideTaxiParkDataFlag';

import { getCarSpeed } from 'entities/Car/helpers/getCarSpeed/getCarSpeed';

import { CarNumberLabel } from 'components/Cars/CarNumberLabel';
import CarStatus from 'components/Cars/CarStatus';
import { StatusTypes } from 'components/types';
import Header4 from 'components/ui/Text/Header4';

import { i18n } from 'components/Cars/CarMapTooltip/index.i18n';

import style from 'components/Cars/CarMapTooltip/index.css';

interface ICarMapTooltipProps {
    carInfo: ICarInfo;
    address: string | null;
    addressLoading: boolean;
}

export const CarMapTooltip = (props: ICarMapTooltipProps) => {
    let { carInfo, address, addressLoading } = props;

    const speed = getCarSpeed(carInfo);
    let { model = null, status = StatusTypes.UNKNOWN, telematics, taxi_park = null } = carInfo ?? {};
    let { fuel_level = null, ext_voltage = null } = telematics ?? {};

    return (
        <div className={style.car_map_tooltip_container}>
            <div className={style.car_map_tooltip}>
                <div className={style.car_main_info}>
                    <Header4 className={style.car_model}>{model ?? EMPTY_DATA}</Header4>
                    <div className={style.car_status}>
                        <CarNumberLabel
                            carInfo={carInfo}
                            shortVIN
                        />

                        <CarStatus carInfo={carInfo} />
                    </div>
                </div>
                <div className={style.separator_line} />
                <div className={style.car_sensors_info}>
                    <div className={style.location_info}>
                        <div className={`${style.title} ${style.location}`}>{i18n('Current Location')}</div>
                        <div className={`${style.info} ${style.location}`}>
                            {!addressLoading ? (
                                status !== StatusTypes.NO_SIGNAL && address ? (
                                    address
                                ) : (
                                    EMPTY_DATA
                                )
                            ) : (
                                <div>
                                    <div className={style.address_mock_line} />
                                    <div className={style.address_mock_line} />
                                </div>
                            )}
                        </div>
                    </div>
                    {Boolean(!getHideTaxiParkDataFlag() && taxi_park) ? (
                        <div className={style.taxi_park_info}>
                            <div className={`${style.title} ${style.taxi_park}`}>{i18n('Taxi park')}</div>
                            <div className={`${style.info} ${style.taxi_park}`}>{taxi_park ?? null}</div>
                        </div>
                    ) : null}

                    <div className={style.sensors_info}>
                        {Boolean(telematics) && (
                            <>
                                <div>
                                    <div className={`${style.title} ${style.sensor}`}>{i18n('Fuel')}</div>
                                    <div className={`${style.info} ${style.sensor}`}>
                                        {fuel_level !== null &&
                                        status !== StatusTypes.NO_SIGNAL &&
                                        typeof fuel_level === 'number'
                                            ? `${fuel_level.toFixed(1)} %`
                                            : EMPTY_DATA}
                                    </div>
                                </div>
                                <div>
                                    <div className={`${style.title} ${style.sensor}`}>{i18n('Battery')}</div>
                                    <div className={`${style.info} ${style.sensor}`}>
                                        {ext_voltage !== null && status !== StatusTypes.NO_SIGNAL
                                            ? `${ext_voltage.toFixed(1)} V`
                                            : EMPTY_DATA}
                                    </div>
                                </div>
                            </>
                        )}

                        <div>
                            <div className={`${style.title} ${style.sensor}`}>{i18n('Current speed')}</div>
                            <div className={`${style.info} ${style.sensor}`}>{speed}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};
