import React from 'react';

import { getCarNumber } from 'entities/Car';

import style from 'components/Cars/CarNumberLabel/index.css';

interface ICarNumberLabelProps {
    carInfo: { number?: string; vin?: string };
    dark?: boolean;
    onlyText?: boolean; //if true, component returns only formatted number without styles
    shortVIN?: boolean; //if true, show only few last numbers of VIN
}

export const CarNumberLabel = ({ carInfo, dark, onlyText, shortVIN }: ICarNumberLabelProps) => {
    let { number, vin } = carInfo || {};

    let text = getCarNumber(number, vin, shortVIN);

    return (
        <span>
            {!onlyText ? (
                <span className={`${style.car_number_label} ${dark ? style.dark : ''}`}>{text}</span>
            ) : (
                <>{text}</>
            )}
        </span>
    );
};
