import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Battery charge': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Battery charge',
        ru: 'Заряд',
        cs: 'Nabití baterie',
    },
    'Current speed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current speed',
        ru: 'Текущая скорость',
        cs: 'Aktuální rychlost',
    },
    Fuel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel',
        ru: 'Топливо',
        cs: 'Stav nádrže',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
