import React from 'react';

import { i18n } from 'components/Cars/CarSensorLabel/index.i18n';

import style from 'components/Cars/CarSensorLabel/index.css';

interface ICarSensorLabelProps {
    sensorName: 'Fuel' | 'Battery' | 'Current speed';
    sensorValue: string;
}

export const CarSensorLabel = (props: ICarSensorLabelProps) => {
    let { sensorName, sensorValue } = props;
    let sensor_type = '';
    let sensorText: string | null = null;

    switch (sensorName.toLowerCase()) {
        case 'fuel':
            sensor_type = 'fuel';
            sensorText = i18n('Fuel');
            break;
        case 'battery':
            sensor_type = 'battery';
            sensorText = i18n('Battery charge');
            break;
        case 'current speed':
            sensor_type = 'speed';
            sensorText = i18n('Current speed');
            break;
    }

    return (
        <div className={style.car_sensor_label}>
            <div className={`${style.icon} ${style[sensor_type]}`} />
            <div className={style.sensor_info}>
                <div className={style.sensor_name}>{sensorText ? sensorText : sensorName}</div>
                <div className={style.sensor_value}>{sensorValue}</div>
            </div>
        </div>
    );
};
