import React from 'react';

import { ICarInfo } from 'utils/car/types';

import { CarSchema } from 'entities/Car/types/CarSchema';

import { SERVICE_TAG } from 'components/Cars/constants';
import { StatusTypes } from 'components/types';
import { Status } from 'components/ui/Status';
import Subhead1 from 'components/ui/Text/Subhead1';

import { i18n } from 'components/Cars/CarStatus/index.i18n';

import style from 'components/Cars/CarStatus/index.css';

interface ICarStatusProps {
    carInfo: ICarInfo | CarSchema;
    big?: boolean;
    dark?: boolean;
    customLabel?: string;
    oneRow?: boolean;
    customStatus?: React.ReactNode;
}

const CarStatus = ({ carInfo, big, dark, customLabel, oneRow, customStatus }: ICarStatusProps) => {
    const { status = StatusTypes.UNKNOWN } = carInfo || {};
    let isCarInService = (carInfo?.tags ?? []).find((tag) => tag.tag === SERVICE_TAG) ?? false;

    return (
        <div className={`${style.car_status} ${oneRow ? style.one_row : ''}`}>
            {customStatus ? (
                customStatus
            ) : (
                <Status
                    big={big}
                    dark={dark}
                    customLabel={customLabel}
                    statusType={status}
                />
            )}

            {isCarInService ? <Subhead1 className={style.service_label}>{`(${i18n('Service')})`}</Subhead1> : null}
        </div>
    );
};

export default CarStatus;
