import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    'Create your first group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create your first group',
        ru: 'Создайте свою первую группу',
        cs: 'Vytvořte svou první skupinu',
    },
    'Filter the cars and save as a group. It will appear here.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Filter the cars and save as a group. It will appear here.',
        ru: 'Отфильтруйте машины и сохраните в виде группы. Она появится здесь.',
        cs: 'Filtrujte vozy a uložte jako skupinu. Zobrazí se zde.',
    },
    'For company': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'For company',
        ru: 'Для компании',
        cs: 'Pro firmu',
    },
    'For me': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'For me',
        ru: 'Для меня',
        cs: 'Pro mě',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
