import React, { useState } from 'react';

import GroupModal from 'components/Cars/CarsGroups/GroupModal';
import ControlButton, { ButtonSize } from 'components/ui/Buttons/ControlButton';
import { Separator } from 'components/ui/SectionLayout/SidebarFilterItem';

import { i18n } from 'components/Cars/CarsGroups/CarsGroupsSidebar/index.i18n';

import AddIcon from 'components/Cars/CarsGroups/CarsGroupsSidebar/add.component.svg';

import style from 'components/Cars/CarsGroups/CarsGroupsSidebar/index.css';

const CarsGroupsSidebar = ({ getGroups }: { getGroups: () => void }) => {
    const [isAddModalOpen, setIsAddModalOpen] = useState<boolean>(false);

    const onAddClick = () => {
        setIsAddModalOpen(true);
    };

    const onAddModalClose = (success: boolean) => {
        if (success) {
            getGroups();
        }
        setIsAddModalOpen(false);
    };

    return (
        <div>
            <div className={style.add_button_container}>
                <ControlButton
                    size={ButtonSize.M}
                    tertiary
                    fullWidth
                    leftAlign
                    title={
                        <>
                            <AddIcon />
                            {i18n('Add')}
                        </>
                    }
                    onClick={onAddClick}
                />
            </div>
            <Separator />
            {isAddModalOpen ? <GroupModal onClose={onAddModalClose} /> : null}
        </div>
    );
};

export default CarsGroupsSidebar;
