import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'A group with such filters already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'A group with such filters already exists',
        ru: 'Группа с такими фильтрами уже существует',
        cs: 'Skupina s těmito filtry již existuje',
    },
    'A group with the same name already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'A group with the same name already exists',
        ru: 'Группа с таким названием уже существует',
        cs: 'Skupina se stejným názvem již existuje',
    },
    Access: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Access',
        ru: 'Доступ',
        cs: 'Přístup',
    },
    "Can't create group with empty filters": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "Can't create group with empty filters",
        ru: 'Нельзя создать группу с пустыми фильтрами',
        cs: 'Nelze vytvořit skupinu s prázdnými filtry',
    },
    Create: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create',
        ru: 'Создать',
        cs: 'Vytvořit',
    },
    'Create new group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create new group',
        ru: 'Создать новую группу',
        cs: 'Vytvořit novou skupinu',
    },
    Description: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Description',
        ru: 'Описание',
        cs: 'Popis',
    },
    'For company': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'For company',
        ru: 'Для компании',
        cs: 'Pro firmu',
    },
    'Group name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group name',
        ru: 'Название группы',
        cs: 'Název skupiny',
    },
    'Only for me': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Only for me',
        ru: 'Только для меня',
        cs: 'Pouze pro mě',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
