import React, { MutableRefObject, useEffect, useRef, useState } from 'react';
import { useLocation } from 'react-router-dom';

import { MODAL_OBJECT_TYPE_CGI } from 'constants/constants';

import { Header } from 'widgets/Header';

import { CarsHeaderTabs } from 'features/CarsHeaderTabs';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import CarsGroupsContent from 'components/Cars/CarsGroups/CarsGroupsContent';
import { CARS_GROUPS_REQUESTS, REQUESTS } from 'components/Cars/CarsGroups/request';
import { IGroup } from 'components/Cars/CarsGroups/types';

import { RequestHelper } from '../../../../request-helper/src';

import { i18n } from 'components/Cars/CarsGroups/index.i18n';

const CarsGroups = () => {
    const [isLoading, setIsLoading] = useState<boolean>(true);
    const [error, setError] = useState<Error | null>(null);
    const [groups, setGroups] = useState<IGroup[]>([]);
    const [isGlobalSidebarOpen, setIsGlobalSidebarOpen] = useState<boolean>(false);
    const request: MutableRefObject<RequestHelper> = useRef(
        new RequestHelper({ requestConfigs: CARS_GROUPS_REQUESTS }),
    );

    let location = useLocation();

    useEffect(() => {
        getGroups();
    }, []);

    useEffect(() => {
        let searchParams = new URLSearchParams(location.search);
        let isGlobalSidebarOpenSearch = searchParams.get(MODAL_OBJECT_TYPE_CGI);
        if (isGlobalSidebarOpen !== !!isGlobalSidebarOpenSearch) {
            if (!isGlobalSidebarOpenSearch) {
                //when sidebar is closed, update groups
                getGroups();
            }
            setIsGlobalSidebarOpen(!!isGlobalSidebarOpenSearch);
        }
    }, [location]);

    const getGroups = () => {
        setIsLoading(true);
        setError(null);
        request.current
            .exec(REQUESTS.GET_GROUPS)
            .finally(() => {
                setIsLoading(false);
            })
            .then((response: { objects: { company_named_filters: IGroup[]; self_named_filters: IGroup[] } }) => {
                let groups = [
                    ...(response.objects.company_named_filters ?? []).map((group) => {
                        group.visibility = 'company';

                        return group;
                    }),
                    ...(response.objects.self_named_filters ?? []).map((group) => {
                        group.visibility = 'user';

                        return group;
                    }),
                ];

                setGroups(groups);
            })
            .catch(setError);
    };

    return (
        <SectionLayout
            header={
                <Header
                    title={i18n('Cars')}
                    tabs={<CarsHeaderTabs />}
                    withoutBorder
                />
            }

            // filters={<CarsGroupsSidebar getGroups={getGroups}/>}
        >
            <ContentContainer bodyScroll>
                <CarsGroupsContent
                    groups={groups}
                    getGroups={getGroups}
                    isLoading={isLoading}
                    error={error}
                />
            </ContentContainer>
        </SectionLayout>
    );
};

export default CarsGroups;
