import { RequestHelperConfigs, RequestHelperMethod } from '../../../../request-helper/src';

enum REQUESTS {
    GET_GROUPS = 'GET_GROUPS',
    ADD_GROUP = 'ADD_GROUP',
    UPSERT_GROUP = 'UPSERT_GROUP',
    REMOVE_GROUP = 'REMOVE_GROUP',
}

const CARS_GROUPS_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_GROUPS]: {
        api: 'named_filters/get',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.ADD_GROUP]: {
        api: 'named_filters/add',
        method: RequestHelperMethod.POST,
        cgiObj: {
            to_organization: null,
        },
    },
    [REQUESTS.UPSERT_GROUP]: {
        api: 'named_filters/upsert',
        method: RequestHelperMethod.POST,
    },
    [REQUESTS.REMOVE_GROUP]: {
        api: 'named_filters/remove',
        method: RequestHelperMethod.POST,
    },
};

export { CARS_GROUPS_REQUESTS, REQUESTS };
