import React from 'react';

import DeleteIcon from 'components/Cars/CarsSidebar/CustomizeTableButton/CustomizeTableModal/CustomizeTableItem/delete.component.svg';

import style from 'components/Cars/CarsSidebar/CustomizeTableButton/CustomizeTableModal/CustomizeTableItem/index.css';

interface ICustomizeTableItemProps {
    displayName: string;
    required?: boolean;
    onRemoveColumn: () => {};
}

const CustomizeTableItem = ({ displayName, required, onRemoveColumn }: ICustomizeTableItemProps) => {
    return (
        <div className={`${style.customize_table_item} ${required ? style.required : ''}`}>
            <span>{displayName}</span>
            <div
                className={style.delete_icon}
                onClick={onRemoveColumn}
            >
                <DeleteIcon />
            </div>
        </div>
    );
};

export default CustomizeTableItem;
