import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add column': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add column',
        ru: 'Добавить колонку',
        cs: 'Přidat sloupec',
    },
    'Column name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Column name',
        ru: 'Название колонки',
        cs: 'Název sloupce',
    },
    'Reset settings': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Reset settings',
        ru: 'Сбросить настройки',
        cs: 'Obnovit nastavení',
    },
    Save: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Save',
        ru: 'Сохранить',
        cs: 'Uložit',
    },
    'Table customization': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Table customization',
        ru: 'Настройка таблицы',
        cs: 'Přizpůsobení tabulky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
