import React, { useState } from 'react';

import { MetrikaLabel } from 'shared/consts/MetrikaLabel';

import CustomizeTableModal from 'components/Cars/CarsSidebar/CustomizeTableButton/CustomizeTableModal';
import ControlButton, { ButtonSize } from 'components/ui/Buttons/ControlButton';
import { IHeaderInfo } from 'components/ui/Table/types';

import { i18n } from 'components/Cars/CarsSidebar/CustomizeTableButton/index.i18n';

import Icon from 'components/Cars/CarsSidebar/CustomizeTableButton/icon.component.svg';

export const TABLE_VIEW_SETTINGS_KEY_PREFIX = 'table_view_';

const CustomizeTableButton = ({
    onClose,
    defaultColumns,
    tableType,
    filterColumns,
    requiredColumns,
    headers,
}: {
    onClose: (columns?: string[]) => void;
    defaultColumns: string[];
    tableType: string;
    headers: IHeaderInfo[];
    requiredColumns: string[];
    filterColumns?: (arr: string[]) => string[];
}) => {
    const [isCustomizeModalOpen, setIsCustomizeModalOpen] = useState<boolean>(false);

    const onOpenModal = () => {
        setIsCustomizeModalOpen(true);
    };

    const onCloseModal = (columns?: string[]) => {
        setIsCustomizeModalOpen(false);
        if (columns) {
            onClose(columns);
        }
    };

    return (
        <>
            <ControlButton
                metrikaLabel={MetrikaLabel.CUSTOMIZE_TABLE}
                size={ButtonSize.M}
                tertiary
                fullWidth
                leftAlign
                title={
                    <>
                        <Icon />
                        {i18n('Customize table view')}
                    </>
                }
                onClick={onOpenModal}
            />

            {isCustomizeModalOpen ? (
                <CustomizeTableModal
                    defaultColumns={defaultColumns}
                    tableType={tableType}
                    onCloseModal={onCloseModal}
                    filterColumns={filterColumns}
                    requiredColumns={requiredColumns}
                    headers={headers}
                />
            ) : null}
        </>
    );
};

export default CustomizeTableButton;
