import { isShowCarCameraStatusFiltersFlag } from 'utils/isShowCarCameraStatusFiltersFlag';

import { IHeaderInfo } from 'components/ui/Table/types';

import { i18n } from 'components/Cars/CarsTable/constants.i18n';

export const CARS_HEADER: IHeaderInfo[] = [
    { key: 'model', displayName: i18n('Model') },
    { key: 'number', displayName: i18n('Number') },
    { key: 'status', displayName: i18n('Status') },
    ...(isShowCarCameraStatusFiltersFlag() ? [{ key: 'signalq_status', displayName: i18n('Camera status') }] : []),
    { key: 'gsm_signal_level', displayName: i18n('GSM signal') },
    { key: 'gps_value', displayName: i18n('GPS signal') },
    { key: 'sh', displayName: i18n('SH'), sorting: true },
    { key: 'utilization', displayName: i18n('Utilization'), sorting: true },
    { key: 'taxi_park', displayName: i18n('Taxi park') },
    { key: 'vin', displayName: i18n('VIN') },
    { key: 'mileage', displayName: i18n('Mileage') },
    { key: 'location', displayName: i18n('Current Location') },
    { key: 'ext_voltage', displayName: i18n('Battery charge') },
    { key: 'speed', displayName: i18n('Current speed') },
    { key: 'fuel_level', displayName: i18n('Fuel') },
    { key: 'fuel_distance', displayName: i18n('Range') },
    { key: 'engine_temperature', displayName: i18n('Engine temp.') },
    { key: 'scoring', displayName: i18n('Scoring') },
];

export const DEFAULT_CARS_COLUMNS = [
    'model',
    'number',
    'status',
    'gsm_signal_level',
    'gps_value',
    'sh',
    'utilization',
    'taxi_park',
];

export const REQUIRED_CARS_COLUMNS = ['model', 'number'];
