import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_CARS = 'GET_CARS',
    GET_CAR_SESSIONS = 'GET_CAR_SESSIONS',
    GET_TAXI_PARKS = 'GET_TAXI_PARKS',
    GET_TRACE = 'GET_TRACE',
    GET_CAR_TELEMATICS = 'GET_CAR_TELEMATICS',
    AREAS_INFO = 'AREAS_INFO',
    TRACE_TAGS = 'TRACE_TAGS',
    GET_TELEMATICS_HISTORY = 'GET_TELEMATICS_HISTORY',
    GET_SCORING_HISTORY = 'GET_SCORING_HISTORY',
    GET_PARK_STATS = 'GET_PARK_STATS',
    EDIT_CAR = 'EDIT_CAR',
    GET_CAR_BEACON = 'GET_CAR_BEACON',
    GET_PHOTOS = 'GET_PHOTOS',
}

const CARS_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            page_number: null,
            page_size: null,
            tags_filter: null,
            no_sh: null,
            no_mileage: null,
            sla: null,
            fines: null,
            cars_type: null,
            sensors: null,
            car_id: null,
            traits: null,
            sort: null,
            order_field: null,
            order_desc: null,
            status: null,
            signalq_status_filter: null,
        },
    },
    [REQUESTS.GET_CAR_SESSIONS]: {
        api: 'sessions/history2',
        cgiObj: {
            car_id: null,
            session_id: null,
            since: null,
            until: null,
            numdoc: null,
            traits: null,
            user_info: true,
        },
    },
    [REQUESTS.GET_TRACE]: {
        api: 'track/analyzer',
        cgiObj: {
            session_id: null,
            speed_threshold: null,
            length_threshold: null,
        },
    },
    [REQUESTS.GET_TAXI_PARKS]: {
        api: 'taxi_companies/list',
        method: RequestHelperMethod.POST,
        cgiObj: {
            page_size: null,
            page_number: null,
        },
    },
    [REQUESTS.GET_PARK_STATS]: {
        api: 'taxi_company/stats',
        method: RequestHelperMethod.GET,
        cgiObj: {
            car_id: null,
            taxi_company_tag_name: null,
            limit: null,
            user_id: null,
            user_taxi_company_tag_name: null,
        },
    },
    [REQUESTS.GET_CAR_TELEMATICS]: {
        api: 'car/telematics/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.AREAS_INFO]: {
        api: 'areas/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.TRACE_TAGS]: {
        api: 'trace/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_HISTORY]: {
        api: 'car/telematics/history',
        cgiObj: {
            car_id: null,
            source: 'ch',
            since: null,
            until: null,
            sensor_id: null,
        },
    },
    [REQUESTS.GET_SCORING_HISTORY]: {
        api: 'car/tag/history',
        cgiObj: {
            tag_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.EDIT_CAR]: {
        api: 'car/edit',
        method: RequestHelperMethod.POST,
    },
    [REQUESTS.GET_CAR_BEACON]: {
        api: 'car/beacon/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_PHOTOS]: {
        api: 'photo/markup/get',
        //apiPrefix: RequestApiPrefix.MOCK,
        cgiObj: {
            session_id: null,
            car_id: null,
            since: null,
            until: null,
            source: null,
            report_dups: null, //true|false
        },
    },
};

export { CARS_REQUESTS, REQUESTS };
