export interface IPassportUserInfoData {
    default_uid: string;
    accounts: {
        uid: string;
        defaultEmail: string;
        displayName: {
            name: string;
            firstname: string;
            lastname: string;
            default_avatar: string;
        };
    }[];
}

export type IPassportUserInfo = OneOf<[IPassportUserInfoData, { data: { email: string } }]>;

export enum MenuItemType {
    CARS = 'cars',
    DASHBOARD = 'dashboard',
    PARK = 'park',
    PORTFOLIO = 'portfolio',
    REPORTS = 'reports',
    RIDES = 'rides',
    SEARCH = 'search',
    USERS = 'users',
    SETTINGS = 'settings',
    SIGNAL = 'signal',
}
