import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Change user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Change user',
        ru: 'Сменить пользователя',
        cs: 'Změnit uživatele',
    },
    'Or ask your manager to grant access': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Or ask your manager to grant access',
        ru: 'Или попросите менеджера дать доступ',
        cs: 'Nebo požádejte svého nadřízeného, aby vám udělil přístup',
    },
    'Please wait.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'EXPIRED',
            },
        },
        en: 'Please wait.',
        ru: 'Подождите, пока вам его дадут.',
        cs: 'Počkejte si.',
    },
    'Reload the page': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Reload the page',
        ru: 'Обновить страницу',
        cs: 'Znovu načíst stránku',
    },
    "You don't have access to this service": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'EXPIRED',
            },
        },
        en: "You don't have access to this service",
        ru: 'Пока что у вас нет доступа к сервису',
        cs: 'Nemáte přístup',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
