import React from 'react';

import { SupportedLanguage } from 'utils/language/types';
import { switchUser } from 'utils/switchUser';

import ErrorView from 'components/ErrorView/index';
import ControlButton from 'components/ui/Buttons/ControlButton';

import { i18n } from 'components/ErrorView/403/index.i18n';

import Icon403 from 'components/ErrorView/403/icon.component.svg';

import styles from 'components/ErrorView/403/index.css';

interface IErrorForbiddenView {
    forceLang?: SupportedLanguage;
    buttonHandler?: () => void;
}

const ErrorForbiddenView = ({ buttonHandler }: IErrorForbiddenView) => {
    const text = (
        <div className={styles.text}>
            <div>{i18n('Please wait.')}</div>
            <div>{i18n('Or ask your manager to grant access')}</div>
        </div>
    );

    return (
        <ErrorView
            title={i18n("You don't have access to this service")}
            textComponent={text}
            customControls={
                <div className={styles.controls}>
                    <ControlButton
                        title={i18n('Reload the page')}
                        onClick={() => {
                            buttonHandler?.();
                        }}
                    />

                    <ControlButton
                        title={i18n('Change user')}
                        secondary
                        onClick={() => {
                            switchUser();
                        }}
                    />
                </div>
            }
            symbol={<Icon403 />}
        />
    );
};

export default ErrorForbiddenView;
